function G_n_storage = G_n_LGD_Markov(num_firms, rho_n)
% --------------------------------------------------------------------------------------------------
% Calculate distribution of portfolio losses conditional on number of defaults, when LGD_n is
% following a Markov chain on {0.3, 0.6, 0.9}.
% --------------------------------------------------------------------------------------------------
% num_firms     ... number of firms
% rho_n         ... transition probability for LGD_(n-1) to LGD_n
% --------------------------------------------------------------------------------------------------
% sample call: G_n_LGD_Markov(20, repmat(0.2, 20, 1))
% --------------------------------------------------------------------------------------------------

% Initialize Markov chain
state_space = [1/3 1/3 1/3]';
G_n_storage{1} = 1;

% Apply joiny transition density
for n=1:num_firms
    % Calculate transition probability matrix
    %P_n = [1-rho_n(n) rho_n(n) 0; rho_n(n)/2 1-rho_n(n) rho_n(n)/2; 0 rho_n(n) 1-rho_n(n)];
    P_n = [1-rho_n(n) rho_n(n)/2 rho_n(n)/2; rho_n(n)/2 1-rho_n(n) rho_n(n)/2; rho_n(n)/2 rho_n(n)/2 1-rho_n(n)];
    
    % Calculate new probability distribution on state space
    state_space_old = state_space;
    state_space = zeros(3, 3*n+1);
    for j=n:(n*3-2)
        for k=1:3
            state_space(k,j+k) = state_space(k,j+k) + state_space_old(:,j)' * P_n(:,k); 
        end
    end
    
    % Calculate G_n 
    G_n_storage{n+1} = sum(state_space(:,(n+1):(n*3+1)),1);
end

% Plot G_n vs. when LGD's are independent
if (0)
    % Binomial G_n
    G_n_storage2 = {};
    for n=1:(num_firms+1)
        G_n_storage2{n} = binopdf_fast(0:(n-1), n-1, 1/3);
    end
    
    % Make Plot
    pos = 26; %21+1;
    scale1 = ((pos-1):(pos*3-3)) * 0.3 / num_firms * 100;
    plot(scale1, G_n_storage{pos}/0.3, 'LineWidth', 1.2);
    hold on;
    scale2 = ((pos-1):(pos*2-2)) * 0.45 / num_firms * 100;
    plot(scale2, G_n_storage2{pos}/0.45, 'Color', 'Red', 'LineStyle', '--', 'LineWidth', 1.2);
    hold off
    xlabel('percloss');
    ylabel('density');
end